<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class DTWPB_Improt_Demo{
		
	public function __construct(){
		if(is_admin()){
			add_action('admin_menu', array($this,'admin_menu'));
			add_action('wp_ajax_dtwpb_import_demo_data', array($this,'ajax_import_demo'));
		}
	}
	
	public function admin_menu(){
		add_submenu_page( 'dtwpb_settings' , esc_html__('Import Demo','dt_woocommerce_page_builder') , esc_html__('Import Demo','dt_woocommerce_page_builder') , 'manage_options' , 'dtwpb-import-demo' , array($this,'output') );
	}
	
	public function output(){
		$config_demos = $this->config_demos();
		
		if ( count( $config_demos ) < 0 ) {
			return;
		}
		reset( $config_demos );
		?>
		<div class="wrap dtwpb-import-demo">
			<form class="dtwpb-importer" action="?page=dtwpb-import-demo" method="post">
				<h1 class="dtwpb-admin-title"><?php esc_html_e('Choose the demo for import','dt_woocommerce_page_builder')?></h1>
				<p class="dtwpb-admin-subtitle"><?php esc_html_e('The demo will give you the layout of the demo version. The style of the demo version is often affected by your theme and plugins.','dt_woocommerce_page_builder');?></p>
				<div class="dtwpb-importer-list">
					<?php foreach ( $config_demos as $name => $import ) {
					?>
						<div class="dtwpb-importer-item" data-demo-id="<?php echo $name; ?>">
	
							<input class="dtwpb-importer-item-radio" id="demo_main" type="radio" value="<?php echo $name; ?>" name="demo">
							<label class="dtwpb-importer-item-preview" for="demo_<?php echo $name; ?>" title="<?php esc_html_e( 'Click to choose', 'dt_woocommerce_page_builder' ) ?>">
								<h2 class="dtwpb-importer-item-title"><?php echo $import['title']; ?>
									<a class="btn" href="<?php echo $import['preview_url']; ?>" target="_blank" title="<?php esc_html_e( 'View this demo in a new tab', 'dt_woocommerce_page_builder' ) ?>"><?php esc_html_e( 'Preview', 'dt_woocommerce_page_builder' ) ?></a>
								</h2>
								<img src="<?php echo DT_WOO_PAGE_BUILDER_URL . 'demo-data/'. $name .'/preview.png' ?>" alt="<?php echo esc_attr($import['title']);?>">
							</label>
	
							<div class="dtwpb-importer-item-options">
								<div class="dtwpb-importer-item-options-h">
									<input type="hidden" name="action" value="import-demo">
									<input class="dtwpb-button-import run_import_demo_data" type="submit" value="<?php esc_html_e('Import','dt_woocommerce_page_builder')?>">
								</div>
							</div>
	
							<div class="dtwpb-importer-message progress">
								<div class="dtwpb-importer-preloader"></div>
								<h2><?php esc_html_e('Importing Demo Content...','dt_woocommerce_page_builder')?></h2>
								<p><?php esc_html_e( 'Don\'t close or refresh this page to not interrupt the import.', 'dt_woocommerce_page_builder' ) ?></p>
							</div>
	
							<div class="dtwpb-importer-message done">
								<h2><?php esc_html_e('Import completed successfully!','dt_woocommerce_page_builder')?></h2>
								<p><?php echo sprintf( __( 'Go to <a href="%s">Settings</a> to set the Template Layout.', 'dt_woocommerce_page_builder' ), admin_url( 'admin.php?page=dtwpb_settings' ) ) ?></p>
							</div>
	
						</div>
					<?php } ?>
				</div>
			</form>
			<script>
				jQuery(document).ready(function() {
					var import_running = false;
	
					jQuery('.dtwpb-importer-item-preview').click(function(){
						var $this_item = jQuery(this).closest('.dtwpb-importer-item'),
							demoName = $this_item.attr('data-demo-id');
	
						jQuery('.dtwpb-importer-item').removeClass('selected');
						$this_item.addClass('selected');
	
	
						$this_item.find('.run_import_demo_data').off('click').click(function(){
							if(import_running) return false;
	
							jQuery('.dtwpb-importer').addClass('importing');
							console.log(demoName);
							jQuery.ajax({
								type: 'POST',
								url: '<?php echo admin_url('admin-ajax.php'); ?>',
								data: {
									security: '<?php echo wp_create_nonce( 'dtwpb_import_demo_data' )?>',
									action: 'dtwpb_import_demo_data',
									demo: demoName
								},
								success: function(response, textStatus, XMLHttpRequest){
									console.log(response);
									
									if(response != 'imported'){
										jQuery('.dtwpb-importer-message.done h2').html(response.error_title);
										jQuery('.dtwpb-importer-message.done p').html(response.error_description);
										jQuery('.dtwpb-importer').addClass('error');
	
									}else{
										// Import is completed
										jQuery('.dtwpb-importer').addClass('success');
										import_running = false;
									}
								},
								error: function(MLHttpRequest, textStatus, errorThrown){
									
									jQuery('.dtwpb-importer-message.done h2').html('<?php esc_html_e('Error has occured','dt_woocommerce_page_builder')?>');
									jQuery('.dtwpb-importer-message.done p').html('');
									jQuery('.dtwpb-importer').addClass('error');
								}
							});
	
							return false;
	
						});
	
					});
	
				});
			</script>
		</div>
		<?php
	}
	
	public function ajax_import_demo(){
		
		if ( ! check_ajax_referer( 'dtwpb_import_demo_data', 'security', FALSE ) ) {
			wp_send_json_error(
			array(
			'message' => __( 'An error has occurred. Please reload the page and try again.' ),
			)
			);
		}
		
		@set_time_limit(0);
		
		$demo_version = 'main';
		if( isset( $_POST['demo'] ) ){
			$demo_version = $_POST['demo'];
		}
		
		$dummy_data_xml_file = DT_WOO_PAGE_BUILDER_DIR . 'demo-data/'. $demo_version .'/dummy-data.xml';
		
		if ( !defined('WP_LOAD_IMPORTERS') ) define('WP_LOAD_IMPORTERS', true);
		
		if ( ! class_exists( 'WP_Importer' ) ) { // if main importer class doesn't exist
			include ABSPATH . 'wp-admin/includes/class-wp-importer.php';
		}
		
		if ( ! class_exists('WP_Import') ) { // if WP importer doesn't exist
			include DT_WOO_PAGE_BUILDER_DIR . 'includes/lib/wordpress-importer/wordpress-importer.php';
		}
		
		if ( class_exists( 'WP_Importer' ) && class_exists( 'WP_Import' ) ) {
			$wp_import = new WP_Import();
			$wp_import->fetch_attachments = true;
			ob_start();
			$wp_import->import($dummy_data_xml_file);
			ob_end_clean();
				
			// Flush rules after install
			flush_rewrite_rules();
		
			echo 'imported';
		
			die();
		
		}else{
			wp_send_json(
			array(
			'success' => FALSE,
			'error_title' => __( 'Error has occured', 'dt_woocommerce_page_builder' ),
			'error_description' => '',
			)
			);
		}
	}
	
	public function config_demos(){
		return array(
			'product-1' => array(
				'title' => 'Product Layout #1',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/product/happy-ninja/',
				'type'	=> 'product',
			),
			'product-2' => array(
				'title' => 'Product Layout #2',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/product/ship-your-idea-2/',
				'type'	=> 'product',
			),
			'product-3' => array(
				'title' => 'Product Layout #3',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/product/woo-ninja-3/',
				'type'	=> 'product',
			),
			'archive-1' => array(
				'title' => 'Archive Layout #1',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/shop/',
				'type'	=> 'archive',
			),
			'archive-2' => array(
				'title' => 'Archive Layout #2',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/product-category/clothing/',
				'type'	=> 'archive',
			),
			'cart-1' => array(
				'title' => 'Cart Layout #1',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/cart/',
				'type'	=> 'cart',
			),
			'cart-2' => array(
				'title' => 'Cart Empty #1',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/cart/',
				'type'	=> 'cart',
			),
			'checkout-1' => array(
				'title' => 'Checkout Layout #1',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/checkout/',
				'type'	=> 'checkout',
			),
			'thankyou-1' => array(
				'title' => 'Thank you Layout #1',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/checkout/order-received/378/?key=wc_order_Xv4idY3dArNL9',
				'type'	=> 'thankyou',
			),
			'myaccount-1' => array(
				'title' => 'My Account Layout #1',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/my-account/',
				'type'	=> 'myaccount',
			),
			'myaccount-2' => array(
				'title' => 'My Account Login #1',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/custom-myaccount-before-login/',
				'type'	=> 'myaccount',
			),
			'myaccount-3' => array(
				'title' => 'Account Details #1',
				'preview_url' => 'http://demo.dawnthemes.com/woocommerce-page-builder/my-account/',
				'type'	=> 'myaccount',
			),
		);
	}
	
	// End Class
}
new DTWPB_Improt_Demo();