<?php
/*
 * Contain all shortcodes for WooCommerce page builder
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit(); // Exit if accessed directly
}
$text_align_options = array( 
	esc_html__( 'Left', 'js_composer' ) => 'left', 
	esc_html__( 'Right', 'js_composer' ) => 'right', 
	esc_html__( 'Center', 'js_composer' ) => 'center', 
	esc_html__( 'Justify', 'js_composer' ) => 'justify' );
$show_hide_values = array( 
	esc_html__( 'Show', 'dt_woocommerce_page_builder' ) => 'show', 
	esc_html__( 'Hide', 'dt_woocommerce_page_builder' ) => 'hide' );
$order_by_values = array( 
	esc_html__( 'Date', 'js_composer' ) => 'date', 
	esc_html__( 'Title', 'js_composer' ) => 'title', 
	esc_html__( 'Price', 'dt_woocommerce_page_builder' ) => 'price', 
	esc_html__( 'popularity', 'dt_woocommerce_page_builder' ) => 'popularity', 
	esc_html__( 'Rating', 'dt_woocommerce_page_builder' ) => 'rating', 
	esc_html__( 'Random order', 'js_composer' ) => 'rand', 
	esc_html__( 'Menu order', 'dt_woocommerce_page_builder' ) => 'menu_order' );

$order = array( 
	esc_html__( 'DESC', 'dt_woocommerce_page_builder' ) => 'desc', 
	esc_html__( 'ASC', 'dt_woocommerce_page_builder' ) => 'asc' );

// Global
vc_map( 
	array( 
		"name" => esc_html__( "Products", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_products", 
		"category" => esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' => esc_html__( "Show responsive multiple products", 'dt_woocommerce_page_builder' ), 
		"params" => array(
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "columns", 
				'value' => array( 
					'1' => '1', 
					'2' => '2', 
					'3' => '3', 
					'4' => '4', 
					'5' => '5', 
					'6' => '6', 
					'7' => '7', 
					'8' => '8', 
					'9' => '9', 
					'10' => '10', 
					'11' => '11', 
					'12' => '12' ), 
				'std' => '4', 
				'save_always' => true, 
				"description" => '' ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Tablet Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "tablet_columns", 
				'value' => array( '1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6' ), 
				'std' => '3', 
				"description" => '' ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Mobile Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "mobile_columns", 
				'value' => array( '1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6' ), 
				'std' => '2', 
				"description" => '' ), 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Rows", 'dt_woocommerce_page_builder' ), 
				"param_name" => "rows", 
				'std' => '3' ),
			////
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array(
				'type' => 'textfield', 
				'heading' => esc_html__( 'Columns Gap', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'column_gap', 
				'value' => '20', 
				'group' => esc_html__( 'Products', 'dt_woocommerce_page_builder' ) ), 
			array(
				'type' => 'textfield', 
				'heading' => esc_html__( 'Rows Gap', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'row_gap', 
				'value' => '40', 
				'group' => esc_html__( 'Products', 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "dropdown",
				"heading" => esc_html__( "Text align", 'dt_woocommerce_page_builder' ), 
				"param_name" => "text_align", 
				'value' => array(
					esc_html__( 'Left', 'js_composer' ) => 'left', 
					esc_html__( 'Right', 'js_composer' ) => 'right', 
					esc_html__( 'Center', 'js_composer' ) => 'center' ), 
				'group' => esc_html__( 'Products', 'dt_woocommerce_page_builder' ) ), 
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Source", 'dt_woocommerce_page_builder' ),
				"param_name" => "query_post_type",
				'value' => array(
					'' => 'products',
					esc_html__( 'Latest Products', 'dt_woocommerce_page_builder' ) => 'recent_products',
					esc_html__( 'On Sale', 'dt_woocommerce_page_builder' ) => 'sale_products',
					esc_html__( 'Best Selling', 'dt_woocommerce_page_builder' ) => 'best_selling_products',
					esc_html__( 'Featured', 'dt_woocommerce_page_builder' ) => 'featured_products',
					esc_html__( 'Top Rated', 'dt_woocommerce_page_builder' ) => 'top_rated_products',
					esc_html__( 'Manual Selection', 'dt_woocommerce_page_builder' ) => 'by_id' ),
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ),
			array(
				"type" => "dtwpb_field_categories",
				"heading" => esc_html__( "Categories", 'dt_woocommerce_page_builder' ),
				"param_name" => "category",
				'dependency' => array( 'element' => 'query_post_type', 'value' => array( 'recent_products', 'sale_products', 'featured_products' ) ),
				"description" => esc_html__( "List of product categories", 'dt_woocommerce_page_builder' ),
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ),
			array( 
				"type" => "dtwpb_field_tags", 
				"heading" => esc_html__( "Tags", 'dt_woocommerce_page_builder' ), 
				"param_name" => "tag", 
				'dependency' => array( 'element' => 'query_post_type', 'value' => array( 'recent_products', 'sale_products', 'featured_products' ) ), 
				"description" => esc_html__( "List of product Tags", 'dt_woocommerce_page_builder' ), 
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "dtwpb_field_ids", 
				"heading" => esc_html__( "Products", 'dt_woocommerce_page_builder' ), 
				"param_name" => "ids", 
				'dependency' => array( 'element' => 'query_post_type', 'value' => array( 'by_id' ) ), 
				"description" => esc_html__( "List of product IDs", 'dt_woocommerce_page_builder' ), 
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Order By", 'dt_woocommerce_page_builder' ), 
				"param_name" => "orderby", 
				"std" => "date", 
				'dependency' => array( 
					'element' => 'query_post_type', 
					'value' => array( 'recent_products', 'sale_products', 'featured_products', 'by_id' ) ), 
				'value' => $order_by_values, 
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Order", 'dt_woocommerce_page_builder' ), 
				"param_name" => "order", 
				'dependency' => array( 
					'element' => 'query_post_type', 
					'value' => array( 'recent_products', 'sale_products', 'featured_products', 'by_id' ) ), 
				"std" => "desc", 
				'value' => $order, 
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ),
			array(
				"type" => "textfield",
				"heading" =>esc_html__( "Nothing Found Message", 'dt_woocommerce_page_builder' ),
				"param_name" => "nothing_found_message",
				'save_always' => true,
				'std' =>esc_html__( "No products were found matching your selection.", 'dt_woocommerce_page_builder' ),
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ),
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "WooCommerce Pages", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_pages", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( 'Display the content of WooCommerce Pages.', 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Page", 'dt_woocommerce_page_builder' ), 
				"param_name" => "page", 
				'value' => array( 
					esc_html__( '- Select - ', 'dt_woocommerce_page_builder' ) => '', 
					esc_html__( 'Cart Page', 'dt_woocommerce_page_builder' ) => 'woocommerce_cart', 
					esc_html__( 'Checkout Page', 'dt_woocommerce_page_builder' ) => 'woocommerce_checkout', 
					esc_html__( 'Single Product Page', 'dt_woocommerce_page_builder' ) => 'product_page', 
					esc_html__( 'Order Tracking Form', 'dt_woocommerce_page_builder' ) => 'woocommerce_order_tracking', 
					esc_html__( 'My Account', 'dt_woocommerce_page_builder' ) => 'woocommerce_my_account' ) ), 
			array( 
				"type" => "dtwpb_field_ids", 
				"multiple" => false, 
				"heading" => esc_html__( "Product", 'dt_woocommerce_page_builder' ), 
				"param_name" => "id", 
				'dependency' => array( 'element' => 'page', 'value' => array( 'product_page' ) ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Product Categories", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_product_categories", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( 'Display product categories loop.', 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "columns", 
				'value' => array( 
					'1' => '1', 
					'2' => '2', 
					'3' => '3', 
					'4' => '4', 
					'5' => '5', 
					'6' => '6', 
					'7' => '7', 
					'8' => '8', 
					'9' => '9', 
					'10' => '10', 
					'11' => '11', 
					'12' => '12' ), 
				'std' => '4', 
				'save_always' => true, 
				"description" => '' ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Tablet Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "tablet_columns", 
				'value' => array( '1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6' ), 
				'std' => '3', 
				"description" => '' ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Mobile Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "mobile_columns", 
				'value' => array( '1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6' ), 
				'std' => '2', 
				"description" => '' ), 
			
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Categories Count", 'dt_woocommerce_page_builder' ), 
				"param_name" => "limit", 
				'value' => '', 
				'std' => '-1', 
				"description" => '' ), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Columns Gap', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'column_gap', 
				'value' => '20', 
				'group' => esc_html__( 'Products', 'dt_woocommerce_page_builder' ) ), 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Rows Gap', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'row_gap', 
				'value' => '40', 
				'group' => esc_html__( 'Products', 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Text align", 'dt_woocommerce_page_builder' ), 
				"param_name" => "text_align", 
				'value' => array( 
					esc_html__( 'Left', 'js_composer' ) => 'left', 
					esc_html__( 'Right', 'js_composer' ) => 'right', 
					esc_html__( 'Center', 'js_composer' ) => 'center' ), 
				'group' => esc_html__( 'Products', 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Source", 'dt_woocommerce_page_builder' ), 
				"param_name" => "source", 
				'value' => array( 
					esc_html__( 'Show All', 'dt_woocommerce_page_builder' ) => '', 
					esc_html__( 'Manual Selection', 'dt_woocommerce_page_builder' ) => 'by_id', 
					esc_html__( 'By Parent', 'dt_woocommerce_page_builder' ) => 'by_parent', 
					esc_html__( 'Current Subcategories', 'dt_woocommerce_page_builder' ) => 'current_subcategories' ), 
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ), 
			array(
				"type" => "dtwpb_field_categories",
				"multiple" => false,
				"only_top" => true,
				"heading" => esc_html__( "Parent", 'dt_woocommerce_page_builder' ), 
				"param_name" => "parent",
				'dependency' => array( 'element' => 'source', 'value' => array( 'by_parent' ) ),
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "dtwpb_field_categories", 
				"heading" => esc_html__( "Categories", 'dt_woocommerce_page_builder' ), 
				"param_name" => "categories", 
				'dependency' => array( 'element' => 'source', 'value' => array( 'by_id' ) ), 
				"description" => esc_html__( "List of product categories", 'dt_woocommerce_page_builder' ), 
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Hide Empty", 'dt_woocommerce_page_builder' ), 
				"param_name" => "hide_empty",
				"std" => "0",
				'value' => array( 
					esc_html__( 'Show', 'dt_woocommerce_page_builder' ) => '0', 
					esc_html__( 'Hide', 'dt_woocommerce_page_builder' ) => '1', 
				),
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Order By", 'dt_woocommerce_page_builder' ), 
				"param_name" => "orderby", 
				"std" => "neme",
				'value' => array( 
					esc_html__( 'Name', 'dt_woocommerce_page_builder' ) => 'name', 
					esc_html__( 'Slug', 'dt_woocommerce_page_builder' ) => 'slug', 
					esc_html__( 'Description', 'dt_woocommerce_page_builder' ) => 'description', 
					esc_html__( 'Count', 'dt_woocommerce_page_builder' ) => 'count', 
				), 
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Order", 'dt_woocommerce_page_builder' ), 
				"param_name" => "order", 
				"std" => "desc", 
				'value' => $order, 
				'group' => esc_html__( 'Query', 'dt_woocommerce_page_builder' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "WooCommercePageBuilder Custom Hook", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_custom_hook", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( 'Add custom action hook.', 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Custom Hook", 'dt_woocommerce_page_builder' ), 
				"param_name" => "custom_hook", 
				'value' => '', 
				"description" =>esc_html__( 
					"Add 'custom hook' for your action hook, the plugin or theme action hook.", 
					'dt_woocommerce_page_builder' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
