<?php
/*
 * Contain all shortcodes for WooCommerce page builder
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit(); // Exit if accessed directly
}
$text_align_options = array( 
	esc_html__( 'Left', 'js_composer' ) => 'left', 
	esc_html__( 'Right', 'js_composer' ) => 'right', 
	esc_html__( 'Center', 'js_composer' ) => 'center', 
	esc_html__( 'Justify', 'js_composer' ) => 'justify' );
$show_hide_values = array( 
	esc_html__( 'Show', 'dt_woocommerce_page_builder' ) => 'show', 
	esc_html__( 'Hide', 'dt_woocommerce_page_builder' ) => 'hide' );
$order_by_values = array( 
	'', 
	esc_html__( 'Date', 'js_composer' ) => 'date', 
	esc_html__( 'Order by post ID', 'js_composer' ) => 'ID', 
	esc_html__( 'Author', 'js_composer' ) => 'author', 
	esc_html__( 'Title', 'js_composer' ) => 'title', 
	esc_html__( 'Last modified date', 'js_composer' ) => 'modified', 
	esc_html__( 'Random order', 'js_composer' ) => 'rand', 
	esc_html__( 'Number of comments', 'js_composer' ) => 'comment_count', 
	esc_html__( 'Menu order', 'dt_woocommerce_page_builder' ) => 'menu_order' );

$order_way_values = array( 
	'', 
	esc_html__( 'Descending', 'js_composer' ) => 'DESC', 
	esc_html__( 'Ascending', 'js_composer' ) => 'ASC' );

// global
vc_map( 
	array( 
		"name" => esc_html__( "WooCommercePageBuilder Breadcrumb", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_breadcrumb", 
		"category" => esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' => esc_html__( 'Some themes may not show it and show their breadcrumb.', 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Text align", 'dt_woocommerce_page_builder' ), 
				"param_name" => "text_align", 
				'value' => $text_align_options ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Font size', 'dt_woocommerce_page_builder'),
				'param_name' => 'font_size',
				'description' => esc_html__('Enter font size.', 'dt_woocommerce_page_builder'),
					
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Line height', 'dt_woocommerce_page_builder'),
				'param_name' => 'line_height',
				'description' => esc_html__('Enter line height.', 'dt_woocommerce_page_builder'),
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'dt_woocommerce_page_builder'),
				'param_name' => 'color',
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Link Color', 'dt_woocommerce_page_builder'),
				'param_name' => 'link_color',
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__('Use theme default font family?', 'dt_woocommerce_page_builder'),
				'param_name' => 'use_fonts',
				'value' => array(esc_html__('No', 'dt_woocommerce_page_builder') => 'no'),
				'description' => esc_html__('Use font family from the theme.', 'dt_woocommerce_page_builder'),
					
			),
			array(
				'type' => 'google_fonts',
				'param_name' => 'google_fonts',
				'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
				'settings' => array(
					'fields' => array(
						'font_family_description' => esc_html__('Select font family.', 'dt_woocommerce_page_builder'),
						'font_style_description' => esc_html__('Select font styling.', 'dt_woocommerce_page_builder'),
					),
				),
				'dependency' => array(
					'element' => 'use_fonts',
					'value' => 'no',
				),
			),
			vc_map_add_css_animation(),
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
